// UHeaders.cp
// UHeaders.h
// ----------------------------------------------------------------------------------
// File Header class for the Spell Checker project.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
// A static class that represents the data header for a file.  It is static
// and then never actualized into a real object.  Basically this class 
// keeps all the methods dealing with reading and writing header variables
// in one place.  This enables headers to be changed without needing to
// search all over the project for where headers are accessed.
//
// ----------------------------------------------------------------------------------
// History:
// 		Art Pollard			June 94
//			Original.  Simple read/write functions.
//		Clark Goble			08/13/94
//			Made into an static C++ class.
//
// ----------------------------------------------------------------------------------

// ----------------------------------------------------------------------------------
// Includes

//#define TEST

#include "Tspell.h"
#include <stdio.h>
#include "Uio.h"

#ifndef _UHEADERS_
#define _UHEADERS_

class UHeaders {
public:
	static short  WriteMagicNumber1( Uio *DictFile, long MagicNumber );
	static short  WriteMagicNumber1( FILE *DictFile, long MagicNumber );

	static long ReadMagicNumber1( Uio *DictFile );
	static long ReadMagicNumber1( FILE *DictFile );

	static short  WriteBloomFilterSize( Uio *DictFile, long BloomFilterSize );
	static short  WriteBloomFilterSize( FILE *DictFile, long BloomFilterSize );

	static long ReadBloomFilterSize( Uio *DictFile );
	static long ReadBloomFilterSize( FILE *DictFile );

	static short  WriteBloomFilterOffset( Uio *DictFile, long BloomFilterOffset );
	static short  WriteBloomFilterOffset( FILE *DictFile, long BloomFilterOffset );

	static long ReadBloomFilterOffset( Uio *DictFile );
	static long ReadBloomFilterOffset( FILE *DictFile );

	static short  WriteIndexOffset( Uio *DictFile, long IndexOffset );
	static short  WriteIndexOffset( FILE *DictFile, long IndexOffset );

	static long ReadIndexOffset( Uio *DictFile );
	static long ReadIndexOffset( FILE *DictFile );

	static short  WriteIndexLength( Uio *DictFile, long IndexLength );
	static short  WriteIndexLength( FILE *DictFile, long IndexLength );

	static long ReadIndexLength( Uio *DictFile );
	static long ReadIndexLength( FILE *DictFile );

	static short  WriteNumPages( Uio *DictFile, long NumPages );
	static short  WriteNumPages( FILE *DictFile, long NumPages );

	static long ReadNumPages( Uio *DictFile );
	static long ReadNumPages( FILE *DictFile );

	static short  WritePageSize( Uio *DictFile, long PageSize );
	static short  WritePageSize( FILE *DictFile, long PageSize );

	static long ReadPageSize( Uio *DictFile );
	static long ReadPageSize( FILE *DictFile );

	static short  WritePageOffset( Uio *DictFile, long PageOffset );
	static short  WritePageOffset( FILE *DictFile, long PageOffset );

	static long ReadPageOffset( Uio *DictFile );
	static long ReadPageOffset( FILE *DictFile );

	static short  WriteMagicNumber2( Uio *DictFile, long MagicNumber2 );
	static short  WriteMagicNumber2( FILE *DictFile, long MagicNumber2 );

	static long ReadMagicNumber2( Uio *DictFile );
	static long ReadMagicNumber2( FILE *DictFile );

	static short  WriteVersion( Uio *DictFile, long Version );
	static short  WriteVersion( FILE *DictFile, long Version );

	static long ReadVersion( Uio *DictFile );
	static long ReadVersion( FILE *DictFile );

	// ----------------------------------------------------------------------------------
private:
	static	void NumToChar(short NumBytes, unsigned long Num, char *Buf );
	static 	unsigned long CharToNum(short NumBytes, char *Buff);

	static	short WriteNumber( Uio *File, long Number, long Offset );
	static	short WriteNumber( FILE *File, long Number, long Offset );

	static	long ReadNumber(Uio *File,long Offset);
	static	long ReadNumber(FILE *File,long Offset);

}; // UHeader

#endif


